
import SwiftUI
import CoreData

struct InsertCountryView: View {
   @Environment(\.managedObjectContext) var dbContext
   @Environment(\.dismiss) var dismiss
   @State private var inputName: String = ""

   var body: some View {
      VStack {
         HStack {
            Text("Country:")
            TextField("Insert Country", text: $inputName)
               .textFieldStyle(.roundedBorder)
         }
         HStack {
            Spacer()
            Button("Save") {
               let text = inputName.trimmingCharacters(in: .whitespaces)
               if !text.isEmpty {
                  let newCountry = Countries(context: dbContext)
                  newCountry.name = text
                  do {
                     try dbContext.save()
                  } catch {
                     print("Error saving country")
                  }
                  dismiss()
               }
            }
         }
         Spacer()
      }.padding()
   }
}
struct InsertCountryView_Previews: PreviewProvider {
   static var previews: some View {
      InsertCountryView()
         .environment(\.managedObjectContext, ApplicationData.preview.container.viewContext)
   }
}

